------------------------------------------------
--   Entities needed to make rsff compile
------------------------------------------------
entity nand2 is
  port (a, b: in bit; c : out bit);
end nand2;

architecture behave of nand2 is
begin
  c <= not(a and b) after 1 ns;
end behave;

entity mynand is
  port (a, b: in bit; c : out bit);
end mynand;

architecture version1 of mynand is
begin
  c <= not(a and b) after 1 ns;
end version1;
------------------------------------------------



ENTITY rsff   IS
  PORT ( set, reset : IN BIT;
         q, qb : INOUT BIT);
END rsff;

ARCHITECTURE netlist OF rsff IS
  COMPONENT nand2
    PORT ( a, b : IN BIT;
           c    : OUT BIT);
  END COMPONENT;
BEGIN
  U1: nand2
    PORT MAP (set, qb, q);

  U2: nand2
    PORT MAP (reset, q, qb);
END netlist;



ARCHITECTURE behave OF rsff IS
BEGIN
  q <= NOT( qb AND set ) AFTER 2 ns;
  qb <= NOT( q AND reset ) AFTER 2 ns;
END behave;



ARCHITECTURE sequential OF rsff IS
BEGIN
  PROCESS (set, reset )
  BEGIN
    IF set = '1' AND reset = '0' THEN
      q <= '0' AFTER 2 ns;
      qb <= '1' AFTER 4 ns;
    ELSIF set = '0' AND reset = '1' THEN
      q <= '1' AFTER 4 ns;
      qb <='0' AFTER 2 ns;
    ELSIF set = '0' AND reset = '0' THEN
      q <= '1' AFTER 2 ns;
      qb <= '1' AFTER 2 ns;
    END IF;
  END PROCESS;
END sequential;


CONFIGURATION rsffcon1 OF rsff IS
  FOR netlist
    FOR U1,U2 : nand2 USE ENTITY WORK.mynand(version1);
    END FOR;
  END FOR;
END rsffcon1;


CONFIGURATION rsffcon2 OF rsff IS
  FOR behave
  END FOR;
END rsffcon2;





